 ; Ŀ
 ;   Dul - remove underlining from text or all attributes in a block.      
 ;   Ul - add underlining to text or entire blocks.                        
 ;   Copyright 2005 by Rocket Software Ltd.                                
 ;   Everything is part of something which is continuous.                  
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   a list of the (possibly modified) target string and the number of     
 ;   changes made.                                                         
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug end.                                                             
 ; 

 ; Ŀ
 ;   Ul - underline text.                                                  
 ; 
 (DEFUN C:UL (/ *error* snapp ss num typ astra nsav nn1 nn zz asoc1)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if shk (write-line shk))
   (if snapp (setvar "snapmode" snapp))
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get some text.                                                        
 ; 
  (write-line "Select text/blocks to underline: ")
  (setq ss (ssget))
  (setq num 0)
  (while (setq nn1 (ssname ss num))
         (setq num (1+ num))
         (setq typ (cdr (assoc 0 (setq nn (entget nn1)))))
         (cond ((or (= typ "TEXT") (= typ "MTEXT"))          ; Is entity text?
                (setq astra (cdr (setq asoc1 (assoc 1 nn)))) ; get text string
                (setq astra (strcat "%%U" "" astra))
                (entmod (subst (cons 1 astra) asoc1 nn)))
               ((and (= typ "INSERT") (assoc 66 nn))
                (setq nsav nn1)
                (while (/= "SEQEND" (cdr (assoc 0 (setq nn (entget (setq nn1
                                                            (entnext nn1)))))))
                       (setq astra (cdr (setq asoc1 (assoc 1 nn))))
                       (setq astra (strcat "%%U" "" astra))
                       (entmod (subst (cons 1 astra) asoc1 nn)))
                (entupd nsav))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))


 ; Ŀ
 ;   Dul.                                                                  
 ; 
 (DEFUN C:DUL (/ *error* snapp ss num typ astra nsav nn1 nn zz asoc1)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if shk (write-line shk))
   (if snapp (setvar "snapmode" snapp))
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get some text.                                                        
 ; 
  (write-line "Select text/blocks to de-underline: ")
  (setq ss (ssget))
  (setq num 0)
  (while (setq nn1 (ssname ss num))
         (setq num (1+ num))
         (setq typ (cdr (assoc 0 (setq nn (entget nn1)))))
         (cond ((or (= typ "TEXT") (= typ "MTEXT"))          ; Is entity text?
                (setq astra (cdr (setq asoc1 (assoc 1 nn)))) ; get text string
                (setq astra (car (chug "%%U" "" astra)))
                (setq astra (car (chug "%%u" "" astra)))
                (entmod (subst (cons 1 astra) asoc1 nn)))
               ((and (= typ "INSERT") (assoc 66 nn))
                (setq nsav nn1)
                (while (/= "SEQEND" (cdr (assoc 0 (setq nn (entget (setq nn1
                                                            (entnext nn1)))))))
                       (setq astra (cdr (setq asoc1 (assoc 1 nn))))
                       (setq astra (car (chug "%%U" "" astra)))
                       (setq astra (car (chug "%%u" "" astra)))
                       (entmod (subst (cons 1 astra) asoc1 nn)))
                (entupd nsav))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))